/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.jfronny.libjf.web.impl.util;

import io.gitlab.jfronny.libjf.web.api.v1.HttpResponse;
import io.gitlab.jfronny.libjf.web.api.v1.HttpStatusCode;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

public class HttpResponseImpl
implements HttpResponse {
    private final String version;
    private final HttpStatusCode statusCode;
    private final Map<String, Set<String>> header;
    private boolean closed = false;
    private InputStream data;

    public HttpResponseImpl(HttpStatusCode statusCode) {
        this.version = "HTTP/1.1";
        this.statusCode = statusCode;
        this.header = new LinkedHashMap<String, Set<String>>();
        this.addHeader("Connection", "keep-alive");
    }

    @Override
    public HttpResponseImpl addHeader(String key, String value) {
        this.ensureOpen();
        Set valueSet = this.header.computeIfAbsent(key, k -> new LinkedHashSet());
        valueSet.add(value);
        return this;
    }

    @Override
    public HttpResponseImpl removeHeader(String key, String value) {
        this.ensureOpen();
        Set valueSet = this.header.computeIfAbsent(key, k -> new LinkedHashSet());
        valueSet.remove(value);
        return this;
    }

    @Override
    public HttpResponseImpl setData(InputStream dataStream) {
        this.ensureOpen();
        this.data = dataStream;
        return this;
    }

    @Override
    public HttpResponseImpl setData(String data) {
        this.ensureOpen();
        this.setData(new ByteArrayInputStream(data.getBytes(StandardCharsets.UTF_8)));
        return this;
    }

    @Override
    public void write(OutputStream out) throws IOException {
        OutputStreamWriter writer = new OutputStreamWriter(out, StandardCharsets.UTF_8);
        LinkedHashMap<String, Set<String>> finalHeaders = new LinkedHashMap<String, Set<String>>(this.header);
        if (this.data != null) {
            finalHeaders.computeIfAbsent("Transfer-Encoding", k -> new LinkedHashSet()).add("chunked");
        } else {
            finalHeaders.computeIfAbsent("Content-Length", k -> new LinkedHashSet()).add("0");
        }
        this.writeLine(writer, this.version + " " + this.statusCode.getCode() + " " + this.statusCode.getMessage());
        for (Map.Entry e : finalHeaders.entrySet()) {
            if (((Set)e.getValue()).isEmpty()) continue;
            this.writeLine(writer, (String)e.getKey() + ": " + StringUtils.join((Iterable)((Iterable)e.getValue()), (String)", "));
        }
        this.writeLine(writer, "");
        writer.flush();
        if (this.data != null) {
            boolean markSupported = this.data.markSupported();
            if (markSupported) {
                this.data.mark(Integer.MAX_VALUE);
            }
            this.chunkedPipe(this.data, out);
            out.flush();
            if (markSupported) {
                this.data.reset();
            } else {
                this.close();
            }
        }
    }

    @Override
    public void close() throws IOException {
        if (this.data != null) {
            this.data.close();
        }
        this.closed = true;
    }

    private void writeLine(OutputStreamWriter writer, String line) throws IOException {
        writer.write(line + "\r\n");
    }

    private void chunkedPipe(InputStream input, OutputStream output) throws IOException {
        int byteCount;
        byte[] buffer = new byte[1024];
        while ((byteCount = input.read(buffer)) != -1) {
            output.write((Integer.toHexString(byteCount) + "\r\n").getBytes());
            output.write(buffer, 0, byteCount);
            output.write("\r\n".getBytes());
        }
        output.write("0\r\n\r\n".getBytes());
    }

    private void ensureOpen() {
        if (this.closed) {
            throw new UnsupportedOperationException("Response cannot be changed after being closed or written");
        }
    }

    @Override
    public HttpStatusCode getStatusCode() {
        return this.statusCode;
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    @Override
    public Map<String, Set<String>> getHeader() {
        return this.header;
    }

    @Override
    public Set<String> getHeader(String key) {
        Set<String> headerValues = this.header.get(key);
        if (headerValues == null) {
            return Collections.emptySet();
        }
        return headerValues;
    }
}

